<?php

namespace LVR\CreditCard\Tests\Unit\Cards;

use Illuminate\Support\Collection;
use LVR\CreditCard\Cards\Jcb;

class JcbTest extends BaseCardTests
{
    public $instance = Jcb::class;

    /**
     * @return \Illuminate\Support\Collection
     */
    public function validNumbers(): Collection
    {
        return collect([
            '3530111333300000',
            '3566002020360505',
            '3588228280601429',
            '3595904764717581',
            '3517044967420371',
            '3509638449153029',
            '3501613748325634',
            '3528311268001383',
            '3532099731401165',
            '3510171805066657',
            '3511968673777847',
            '3560584305904566',
            '3518283478430458',
            '3534860787708409',
            '3515609696674548',
            '3502356338228706',
            '3598374787662346',
            '3536114212282194',
            '3514788054100683',
            '3546481842636349',
            '3583751792185370',
            '3537196961132075',
            '3513012927849249',
            '3533305571518938',
            '3571384417868644',
            '3586733325170449',
            '3553807314294458',
            '3597154732589120',
            '3569374936842166',
            '3518817907000281',
            '3590966189425806',
            '3510739349061192',
            '3534547416298494',
            '3501240409404472',
            '3556050494567859',
            '3582305218110321',
            '3557530183907523',
            '3553588663432853',
            '3580934034454662',
            '3539232628266069',
            '3563176969590547',
            '3586194643913228',
            '3557065823576297',
            '3566860673430168',
            '3514177016022294',
            '3563637374718577',
            '3512361216304056',
            '3599634223937092',
            '3528627074238079',
            '3588763656363196',
            '3547326175129868',
            '3504442587057752',
            '3582275743773465',
            '3563071096946383',
            '3596070307061710',
            '3549728694774082',
            '3540632109145764',
            '3549508741451110',
            '3508390977475868',
            '3561592334011112',
            '3518539658019696',
            '3532392232853996',
            '3592585784990572',
            '3518470022013779',
            '3572208867439011',
            '3559227698193958',
            '3589715112274945',
            '3529993092203845',
            '3506799835619099',
            '3506497941666639',
            '3535516392293661',
            '3577777841698582',
            '3583919643141914',
            '3526480851173974',
            '3523630973694751',
            '3599746221623787',
            '3543728038428961',
            '3531900441149310',
            '3582381990926515',
            '3583789262522987',
            '3529168966852205',
            '3545202979839907',
            '3529423350979068',
            '3549360069782159',
            '3596144907472690',
            '3580887094345768',
            '3502332035962855',
            '3574921746336723',
            '3596320230412674',
            '3559705631865543',
            '3542433765912573',
            '3527712709029779',
            '3581964879696209',
            '3585297914929020',
            '3537795293911831',
            '3520546122522995',
            '3597010205665690',
            '3587987656762666',
            '3511235128236716',
            '3587718314676794',
            '3500278409448074',
            '3509173789871493',
            '3540285570643435',
            '3529205926839081290',
        ]);
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function numbersWithInvalidLength(): Collection
    {
        return collect([
            '353011',
            '356600202036050',
            '35292059268390812901',
        ]);
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function numbersWithInvalidCheckSum(): Collection
    {
        return collect([
            '3509173789871492',
            '3540285570643434',
            '3529205926839081292',
        ]);
    }
}
